<html> 
<head>
<title>Unpack reports</title>
</head>
<body>

<?php

require('dbconfig.php'); 

$act = strip_tags((string)$_REQUEST['act']);
$path = dirname($_SERVER['SCRIPT_FILENAME']);
if (substr($reports_url, -1) != '/') $reports_url .= '/';	

if ($act == 'delete')
{
 	$curr_file = 0;	
 	$loop = true; 	
 	do
 	{
 		$curr_file++; 		
 		$filename = 'reports_'.strval($curr_file).'.txt';
		if (!file_exists($filename)) 
		{
			$loop = false;
		}
		else
		{
			if (unlink($filename)) echo "Deleted $filename<br>";
		}
	} while ($loop);
		
	$filename = $path.'/reports.tar.gz'; 		if (file_exists($filename)) { if (unlink($filename)) echo 'Deleted reports.tar.gz<br>'; }
	$filename = $path.'/unpackreports.php'; 	if (file_exists($filename)) { if (unlink($filename)) echo 'Deleted unpackreports.php<br><br>'; }
	echo '<a href='.escapeshellarg($reports_url.'index.html').'>Open league reports</a><br>';
}
else
{
	$disabled = explode(', ', ini_get('disable_functions'));
  	if (in_array('exec', $disabled))
	{	
		echo 'The PHP exec command is disabled on your server! Please enable it and try again.';
		exit;
	}	
	echo 'Please wait...<br>';
	
	$cmd = sprintf("tar xzf %s 2>&1", escapeshellarg($path.'/reports.tar.gz'));
		
	echo '<pre>Command: ', htmlspecialchars($cmd), ": \n";
	flush();
	passthru($cmd, $retval);
	echo '</pre>';

	if (intval($retval) > 0)
	{
		echo 'The unpack command returned $retval, looks like it was not completely successful.<br><br>';
	}
	else
	{
		echo 'Successfully unpacked the reports.tar.gz file...<br><br>';
	}		
	flush();

	$db_connection = new mysqli($db_host, $db_user, $db_pass, $db_name, $db_port);
	if ($db_connection->connect_errno) die("Unable to connect to database: " . $db_connection->connect_error);
	$db_connection->set_charset('latin1');

	$querystring = 'CREATE TABLE IF NOT EXISTS `'.$db_table.'` (`id` int(11) NOT NULL auto_increment, `name` varchar(255) NOT NULL, `type` varchar(1) NOT NULL, `md5hash` varchar(32) NOT NULL, PRIMARY KEY (`id`), UNIQUE KEY `type_name` (`type`,`name`)) ENGINE=MyISAM  DEFAULT CHARSET=latin1';
	if ($db_connection->query($querystring) === TRUE) {
	    echo 'Successfully touched table '.$db_table.'<br>';
	} else {
	    die("Error creating table: " . $conn->error);
	}

	$types = 'abcdefghijklmnopqrstuvwxyz';
	for ($i=0; $i<strlen($types); ++$i)
	{
		$querystring = 'CREATE TABLE IF NOT EXISTS `'.$db_table.'_content_'.substr($types, $i, 1).'` (`id` int(11) NOT NULL, `content` mediumtext NOT NULL, PRIMARY KEY (`id`)) ENGINE=MyISAM  DEFAULT CHARSET=latin1';
		if ($db_connection->query($querystring) === TRUE) {
	    		echo 'Successfully touched table '.$db_table.'_content_'.substr($types, $i, 1).'<br>';
		} else {
		    die("Error creating table: " . $conn->error);
		}
	}

	$total_write_success=0;
	$total_write_error=0;
	$total_write_update=0;
	$total_write_insert=0;
	$total_content_unchanged=0;
	$total_valid_lines=0;
	$total_invalid_lines=0;
	
	$counter=0;
 	
 	$curr_file = 0;	
 	$loop = true;
 	
 	do
 	{
		$write_success=0;
		$write_error=0;
		$write_update=0;
		$write_insert=0;
		$content_unchanged=0;
		$valid_lines=0;
		$invalid_lines=0;

 		$curr_file++;
 		
 		$file_name = 'reports_'.strval($curr_file).'.txt';
		if (!file_exists($file_name)) 
		{
			$loop = false;
		}
		else
		{
			$file=fopen($file_name, 'r'); 
			if (!$file)
			{
				echo "Error, could not open file $file_name<br>";
			}
			else
			{
				echo "Opened reports file $file_name...<br>";
				while(!feof($file)) 
				{ 
					flush(); 
					$line = fgets($file); 
					if (strlen($line)>4)
					{
						$counter++;	
						$pos1 = strpos($line, "\t", 0);
						if ($pos1 === false)
						{
							// not found -> invalid string
							$invalid_lines++;
						}
						else
						{
							$type = trim(substr($line, 0, $pos1));
							$pos2 = strpos($line, "\t", $pos1+1);
							if ($pos2 === false)
							{
								// not found -> invalid string
								$invalid_lines++;
							}
							else
							{
								$valid_lines++;
								$name = trim(substr($line, $pos1+1, $pos2-$pos1-1));
								$content = $db_connection->real_escape_string(substr($line, $pos2+1));
								$md5hash = md5($content);
								
								//echo "$counter, $type, $name, ";
								
								// check main table:
								$querystring = 'SELECT id, md5hash FROM '.$db_table.' WHERE (type="'.$db_connection->real_escape_string($type).'" AND name="'.$db_connection->real_escape_string($name).'") LIMIT 1';
								$result = $db_connection->query($querystring);
								if ($result->num_rows > 0)
								{
									if ($row = $result->fetch_assoc()) 
									{
										$id = intval($row['id']);
										if (strcmp($md5hash, strval($row['md5hash']))==0)
										{
											// content did not change!
											$content_unchanged++;
											echo 'Unchanged: '.$db_connection->real_escape_string($type).', '.$db_connection->real_escape_string($name).'<br>'; 
										}
										else
										{										
											// update record in main table
											$querystring = 'UPDATE '.$db_table.' SET md5hash="'.$md5hash.'" WHERE (id='.$id.') LIMIT 1';
											if ($db_connection->query($querystring) !== TRUE) die("Database Query Error: " . $conn->error . ' : ' . $querystring);
											
											$querystring = 'SELECT id FROM '.$db_table.'_content_'.$type.' WHERE (id='.$id.') LIMIT 1';
											$result = $db_connection->query($querystring);
											if ($result->num_rows > 0)
											{									
												// update record in content table
												$querystring = 'UPDATE '.$db_table.'_content_'.$type.' SET content="'.$content.'" WHERE (id='.$id.') LIMIT 1';
												if ($db_connection->query($querystring) !== TRUE) die("Database Query Error: " . $conn->error . ' : ' . $querystring);
												$write_update++;
											}
											else
											{									
												// insert record into content table
												$querystring = 'INSERT INTO '.$db_table.'_content_'.$type.' (id, content) VALUES ('.$id.', "'.$content.'")';
												if ($db_connection->query($querystring) !== TRUE) die("Database Query Error: " . $conn->error . ' : ' . $querystring);
												$write_insert++;
											}
										}										
										//echo 'update, ';
									}
								}
								else
								{
									// insert record into main table
									$querystring = 'INSERT INTO '.$db_table.' (type, name, md5hash) VALUES ("'.$db_connection->real_escape_string($type).'", "'.$db_connection->real_escape_string($name).'", "'.$md5hash.'")';
									if ($db_connection->query($querystring) !== TRUE) die("Database Query Error: " . $conn->error . ' : ' . $querystring);
									$id = intval($db_connection->insert_id);
									// insert record into content table
									$querystring = 'INSERT INTO '.$db_table.'_content_'.$type.' (id, content) VALUES ('.$id.', "'.$content.'")';
									if ($db_connection->query($querystring) !== TRUE) die("Database Query Error: " . $conn->error . ' : ' . $querystring);
									$write_insert++;
									//echo 'insert, ';
								}
															
								if ($result == true)
								{
									$write_success++;				
									//echo 'success<br>';
								}
								else
								{
									$write_error++;
									//echo 'ERROR<br>';
								}			
							}
						}
					}
					else 
					{
						$line=trim($line);
						if (strlen($line)>0)
						{
							echo "Error in line $counter ($line)<br>";
							$invalid_lines++;	
						}
					}
				} 
				fclose($file);  
				
				echo "Valid lines = $valid_lines, ";
				echo "Invalid lines = $invalid_lines, ";
				echo "Inserts = $write_insert, ";
				echo "Updates = $write_update, ";
				echo "Unchanged = $content_unchanged, ";
				echo "Errors = $write_error, ";
				echo "Success = $write_success";
				
				$total_write_success 	+= $write_success;
				$total_write_error	+= $write_error;
				$total_write_update 	+= $write_update;
				$total_write_insert 	+= $write_insert;
				$total_content_unchanged+= $content_unchanged;
				$total_valid_lines	+= $valid_lines;
				$total_invalid_lines 	+= $invalid_lines;
			}			
		}	
		echo '<br>';
		
	} while ($loop);
	
	echo "Valid lines = $total_valid_lines, ";
	echo "Invalid lines = $total_invalid_lines, ";
	echo "Inserts = $total_write_insert, ";
	echo "Updates = $total_write_update, ";
	echo "Unchanged = $total_content_unchanged, ";
	echo "Errors = $total_write_error, ";
	echo "Success = $total_write_success";

	echo '<p>After finishing the job successfully, you should <a href="'.$_SERVER['PHP_SELF'].'?act=delete">delete archive file, reports file and unpack script</a></p><br>';
	
	$querystring = 'SELECT id FROM `'.$db_table.'`';
	$result = $db_connection->query($querystring);
	echo 'Number of records in main table = ' . $result->num_rows . '<br>';
	
	$total_content_records = 0;	
	for ($i=0; $i<strlen($types); ++$i)
	{
		$querystring = 'SELECT id FROM `'.$db_table.'_content_'.substr($types, $i, 1).'`';
		$result = $db_connection->query($querystring);
		echo 'Number of records in content table '.substr($types, $i, 1).' = ' . $result->num_rows . '<br>';
		$total_content_records += $result->num_rows;
	}
	echo 'Total number of records in content tables = '.$total_content_records.'<br>';
	
	$db_connection->close(); 
}
?>

</body>
</html>